/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2006 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      main.c
*
* @author    B01119
* 
* @version   1.0.5.0
* 
* @date      May-27-2009
* 
* @brief     Example for Flash programming, using DoOnStack.asm
*
******************************************************************************/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

#include "doonstack.h" /* include flash utilities */

unsigned char test_source[26];
unsigned char i;


// place destination Flash data into the proper segment, see also project.prm 
#pragma CONST_SEG DEFAULT_EEPROM
const unsigned char test_destination[30] = "Hallo World!";
#pragma CONST_SEG DEFAULT


#define BUSCLOCK 8000000   // BUS clock in Hertz

#ifdef BUSCLOCK
#if (((BUSCLOCK/200000L)-1)>63)
    #define FCDIVVAL ((FCDIV_PRDIV8_MASK | ((((BUSCLOCK/200000L)/8)-1) & FCDIV_DIV_MASK)))
#else
    #define FCDIVVAL (((BUSCLOCK/200000L)-1) & FCDIV_DIV_MASK)
#endif
#else
    #error "BUSCLOCK macro needs to be defined, value in Hertz"
#endif

#define DEBUG asm bgnd

void main(void) 
{
    DEBUG;

    SOPT_COPE = 0;    // disable watchdog

    // set the BUS clock here, ICS, external crystal or whatever
    // RG family has 16MHz crystal = 8MHz BUS clock, no additional settings required

    // initialize Flash clock for 150-200kHz range
    FCDIV = FCDIVVAL;

    for(i=0;i<26;i++) 
        test_source[i] = 'A' + i;

    DEBUG;                    // breakpoint here & see Flash in EEPROM area

    // if the Flash content does not update, check
    // Debugging Memory Map setting refresh memory when halting 
    // in HiWave debugger

    FlashErase(test_destination);

    DEBUG;                    // breakpoint here & see empty Flash

    FlashProg(&test_destination[29], '!');

    DEBUG;                    // breakpoint here & see 1 byte programmed

    if (FlashProgBurst(test_destination, test_source, 26))
    {
      asm nop;  // only if access or violation errors occur
    }

    DEBUG;                    // breakpoint here & see Flash block programmed

    for(;;) 
    {
        i++;
        asm nop;
        __RESET_WATCHDOG(); /* feeds the dog */
    } /* loop forever */
  /* please make sure that you never leave main */
}
