;******************************************************************************
;
; Freescale Semiconductor Inc.
; (c) Copyright 2004-2009 Freescale Semiconductor, Inc.
; (c) Copyright 2001-2004 Motorola, Inc.
; ALL RIGHTS RESERVED.
;
;**************************************************************************//*!
;
;   $File Name: DoOnStack_CFV1.asm$
;
;   $Last Modified By: B20253$
;
;   $Version: 1.0.3.0$
;
;   $Date: Aug-7-2009$ 
;
;   @brief     runonstack_CFV1.asm 
;
;******************************************************************************
; export symbols

.global   _Page_Erase
.global   _Burst_Prog

.include "doonstack_CFV1.inc"
.include "doonstack_CFG.inc"
/********************************************************************************/
.section  code
.text
/*******************************************************************************/
.if(MCU == MCF51_JM_QE_CN_AC)
_Page_Erase:
             move.l  a0,d1
             move.l  #(SpSubEnd),a1
             move.l  #(SpSub),a6
             
             bsr     DoOnStack

             move.l  a0,a1                  /* SET UP FACCER A FPVIOL FLAG TO 1 */
             moveq   #(mFSTAT_FACCERR+mFSTAT_FPVIOL),d0
             move.b  d0,FSTAT
 
             move.l  d1,a0                  /* ADDRESS OF ERASE BLOCK MOVE TO A0 */
             move.l  #0xFF,(a0)             /* DUMMY DATA */
            
             moveq   #mPageErase,d0         /* FLASH COMMAND 0x40 - SECTOR ERASE */
             move.b  d0,FCMD                /* MOVE TO REGISTER FCMD */

             jsr     (A1)                   /* JUMP TO FLASH ROUTINE ON THE STACK */
             rts
.endif

.if(MCU == MCF51EM)             

/* FOR MCF51EM128 - with two independet 128kb blocks */
/*******************************************************************************/
_Page_Erase:
             move.l  a0,d1
             move.l  d1,d6
        
             
         .if(SIZE == 256)                     
             cmpi.l   #0x1FFFF,d6
        .endif         
            
        .if(SIZE == 128)     
             cmpi.l   #0xFFFF,d6
        .endif
   
             bgt.s    SEC_ROUT
                              
             move.l  #(SpSubEnd),a1
             move.l  #(SpSub),a6
             bra     DOONSTACK
             
SEC_ROUT:    move.l  #(SpSubEnd2),a1
             move.l  #(SpSub2),a6
          
DOONSTACK:   bsr     DoOnStack
            
             move.l  a0,a1                  /* SET UP FACCER A FPVIOL FLAG TO 1 */
           
        .if(SIZE == 256)                     
             cmpi.l   #0x1FFFF,d6
        .endif         
            
        .if(SIZE == 128)     
             cmpi.l   #0xFFFF,d6
        .endif
            bgt.s    SECOND_BLOCK

FIRST_BLOCK:           
             move.b   #(mF1STAT_FACCERR+mF1STAT_FPVIOL),d0
             move.b  d0,F1STAT
             
             move.l  d1,a0                 
             move.l  #0xFF,(a0)            
             
             moveq   #mPageErase,d0        
             move.b  d0,F1CMD              
             bra     JMP_STACK
      
SECOND_BLOCK:
             moveq   #(mF2STAT_FACCERR+mF2STAT_FPVIOL),d0
             move.b  d0,F2STAT
 
             move.l  d1,a0                 
             move.l  #0xFF,(a0)            
            
             moveq   #mPageErase,d0        
             move.b  d0,F2CMD              
JMP_STACK:
             jsr     (A1)                   /* JUMP TO FLASH ROUTINE ON THE STACK */
             rts
.endif
/*******************************************************************************/
.if(MCU == MCF51_JM_QE_CN_AC)
_Burst_Prog:
               move.l  d0,d4
               move.l  a1,a3
               move.l  a0,d2

               move.l  #(SpSubBurstEnd),a1
               move.l  #(SpSubBurst),a6

               bsr     DoOnStack
         
               move.l  a0,a1
               move.b  #(mFSTAT_FCCF + mFSTAT_FCBEF),d0
               move.b  d0,FSTAT

               jsr     (A1)
               rts
.endif
/*******************************************************************************/
.if(MCU == MCF51EM)
_Burst_Prog:
             move.l  d0,d4
             move.l  a1,a3
             move.l  a0,d2
             move.l  a0,d6

           .if(SIZE == 256)                     
             cmpi.l   #0x1FFFF,d6
           .endif         
            
           .if(SIZE == 128)     
             cmpi.l   #0xFFFF,d6
           .endif
       
             bgt.s    SEC_ROUT2
                              
             move.l  #(SpSubBurstEnd),a1
             move.l  #(SpSubBurst),a6
             
             bra     DOONSTACK2
             
SEC_ROUT2:   move.l  #(SpSubBurstEnd2),a1
             move.l  #(SpSubBurst2),a6


DOONSTACK2:  bsr     DoOnStack
         
          .if(SIZE == 256)                     
               cmpi.l   #0x1FFFF,d6
          .endif         
              
          .if(SIZE == 128)     
               cmpi.l   #0xFFFF,d6
          .endif
              bgt.s    SECOND_BLOCK2

FIRST_BLOCK2:
               move.l  a0,a1
               move.b  #(mF1STAT_FCCF + mF1STAT_FCBEF),d0
               move.b  d0,F1STAT
               bra     JMP_STACK2
SECOND_BLOCK2:
               move.l  a0,a1
               move.b  #(mF2STAT_FCCF + mF2STAT_FCBEF),d0
               move.b  d0,F2STAT
JMP_STACK2:
               jsr     (A1)
               rts
.endif    
/*******************************************************************************/ 
DoOnStack:
             move.l  A7,A2       /* save actual address SP */
DoOnStack1:
             suba.l  #2,a7       
             
             move.w  (a1),d0
             move.w  d0,(A7)
             
             cmpa.l  a6,a1       /* SELECTED #(SpSubBurst) or #(SpSub) */           
             suba.l  #2,a1
             bne.s   DoOnStack1

             move.l  A7,A0
             move.l  A2,A7
             rts 
/*******************************************************************************/ 
/*******************************************************************************/ 
/***************************** ERASE SUBROUTINE ********************************/
/*********** THIS PART OF SOURCE CODE MUST RUNNING IN RAM **********************/
.if(MCU == MCF51_JM_QE_CN_AC)
  SpSub:
    	         move.b  #mFSTAT_FCBEF,d1          /*   Clear  FCBEF 0x80             */
    		       move.b  d1,(FSTAT)                /*   Write: FSTAT register         */
  loop_1:
               move.l  #FSTAT,a4                 /* Read: FSTAT register            */
               move.b  (a4),d2
             	 moveq   #0,d1          
             	 move.b  d2,d1                     /* FCCF Set? */
             	 andi.l  #0x40,d1       
             	 beq.s   loop_1
  SpSubEnd:
               rts
.endif
/*******************************************************************************/ 
.if(MCU == MCF51EM)               
  
  SpSub:
    	         move.b  #mF1STAT_FCBEF,d1          /*   Clear  FCBEF 0x80             */
    		       move.b  d1,(F1STAT)                /*   Write: FSTAT register         */
  loop_1:
               move.l  #F1STAT,a4                 /* Read: FSTAT register            */
               move.b  (a4),d2
             	 moveq   #0,d1          
             	 move.b  d2,d1                     /* FCCF Set? */
             	 andi.l  #0x40,d1       
             	 beq.s   loop_1
  SpSubEnd:
               rts
/*********************************/ 
  SpSub2:
    	         move.b  #mF2STAT_FCBEF,d1          /*   Clear  FCBEF 0x80             */
    		       move.b  d1,(F2STAT)                /*   Write: FSTAT register         */
  loop_2:
               move.l  #F2STAT,a4                 /* Read: FSTAT register            */
               move.b  (a4),d2
             	 moveq   #0,d1          
             	 move.b  d2,d1                     /* FCCF Set? */
             	 andi.l  #0x40,d1       
             	 beq.s   loop_2
  SpSubEnd2:
               rts
.endif               
/*******************************************************************************/ 
/*********************** FLASH BURST SUBROUTINE ********************************/
/*********** THIS PART OF SOURCE CODE MUST RUNNING IN RAM **********************/
.if(MCU == MCF51_JM_QE_CN_AC)
SpSubBurst:
             move.l  d2,a1              /* SOURCE ADDRESS IN D2 */
SpSubBurst1:                            /* LENGTH IN D4, MUST BE MULTIPLE OF 4 */
loop3:      
             move.b  FSTAT,d0           /* IF COMMAND BUUFER EMPTY FLAG == 0 WAIT */
             btst    #FSTAT_FCBEF,d0
             beq.s   loop3 
            
             move.l  (a3),(a1)          /* POINTER TO DATA IN A3 */
       
             moveq   #mBurstProg,d0     /* BURST COMMAND */                               
             move.b  d0,FCMD

	           move.b  #mFSTAT_FCBEF,d1   /* CLEAR FACCER AND FPVIOL */
		         move.b  d1,(FSTAT)

             addq.l  #4,a1              /* POINTER TO DESTINATION ADDRESS PLUS FOUR BYTES */
             addq.l  #4,a3              /* POINTER TO SOURCE ADDRESS PLUS FOUR BYTES */
            
             subi.l  #4,d4              /* CHECK LENGTH */
             cmpi.b  #0,d4
             bne.s   SpSubBurst1
loop4:       
             move.b  FSTAT,d0                                          
             btst    #FSTAT_FCCF,d0                                          
             beq.s   loop4 
SpSubBurstEnd:
             rts
.endif
/*******************************************************************************/ 
.if(MCU == MCF51EM)
SpSubBurst:
             move.l  d2,a1              /* SOURCE ADDRESS IN D2 */
SpSubBurst1:                            /* LENGTH IN D4, MUST BE MULTIPLE OF 4 */
loop3:      
             move.b  F1STAT,d0           /* IF COMMAND BUUFER EMPTY FLAG == 0 WAIT */
             btst    #F1STAT_FCBEF,d0
             beq.s   loop3 
            
             move.l  (a3),(a1)          /* POINTER TO DATA IN A3 */
       
             moveq   #mBurstProg,d0     /* BURST COMMAND */                               
             move.b  d0,F1CMD

	           move.b  #mF1STAT_FCBEF,d1   /* CLEAR FACCER AND FPVIOL */
		         move.b  d1,(F1STAT)

             addq.l  #4,a1              /* POINTER TO DESTINATION ADDRESS PLUS FOUR BYTES */
             addq.l  #4,a3              /* POINTER TO SOURCE ADDRESS PLUS FOUR BYTES */
            
             subi.l  #4,d4              /* CHECK LENGTH */
             cmpi.b  #0,d4
             bne.s   SpSubBurst1
loop4:       
             move.b  F1STAT,d0                                          
             btst    #F1STAT_FCCF,d0                                          
             beq.s   loop4 
SpSubBurstEnd:
             rts
/********************************/             
SpSubBurst2:
             move.l  d2,a1              /* SOURCE ADDRESS IN D2 */
SpSubBurst0:                            /* LENGTH IN D4, MUST BE MULTIPLE OF 4 */
loop5:      
             move.b  F2STAT,d0           /* IF COMMAND BUUFER EMPTY FLAG == 0 WAIT */
             btst    #F2STAT_FCBEF,d0
             beq.s   loop5 
            
             move.l  (a3),(a1)          /* POINTER TO DATA IN A3 */
       
             moveq   #mBurstProg,d0     /* BURST COMMAND */                               
             move.b  d0,F2CMD

	           move.b  #mF2STAT_FCBEF,d1   /* CLEAR FACCER AND FPVIOL */
		         move.b  d1,(F2STAT)

             addq.l  #4,a1              /* POINTER TO DESTINATION ADDRESS PLUS FOUR BYTES */
             addq.l  #4,a3              /* POINTER TO SOURCE ADDRESS PLUS FOUR BYTES */
            
             subi.l  #4,d4              /* CHECK LENGTH */
             cmpi.b  #0,d4
             bne.s   SpSubBurst0
loop6:       
             move.b  F2STAT,d0                                          
             btst    #F2STAT_FCCF,d0                                          
             beq.s   loop6 
SpSubBurstEnd2:
             rts
             
.endif   
             
