;******************************************************************************
;
; Freescale Semiconductor Inc.
; (c) Copyright 2004-2009 Freescale Semiconductor, Inc.
; (c) Copyright 2001-2004 Motorola, Inc.
; ALL RIGHTS RESERVED.
;
;**************************************************************************//*!
;
;   $File Name: DoOnStack_CFV1.inc$
;
;   $Last Modified By: B20253$
;
;   $Version: 1.0.2.0$
;
;   $Date: Aug-7-2009$ 
;
;   @brief    runonstack_CFV1.inc header file (target dependent)
;
;******************************************************************************
;
; 
;
;*****************************************************************************/

;****  Flash Module (FLASH)
 
;*** FCDIV - FLASH Clock Divider Register; 0xFFFF9820 ***
FCDIV:              .equ   $FFFF9820                                ;*** FCDIV - FLASH Clock Divider 

;*** FCNFG - Flash Configuration Register; 0xFFFF9823 ***
FCNFG:              .equ   $FFFF9823                                ;*** FCNFG - Flash Configuration Register; 
 
;*** FPROT - Flash Protection Register; 0xFFFF9824 ***
FPROT:              .equ   $FFFF9824                                ;*** FPROT - Flash Protection Register; 0xFFFF82E4 ***

;*** FSTAT - Flash Status Register; 0xFFFF9825 ***
FSTAT:              .equ   $FFFF9825                                ;*** FSTAT - Flash Status Register; 0xFFFF82E5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET

FSTAT_FBLANK:       .equ   2                                        ; FLASH Flag Indicating the Erase Verify Operation Status
FSTAT_FACCERR:      .equ   4                                        ; FLASH Access Error Flag
FSTAT_FPVIOL:       .equ   5                                        ; FLASH Protection Violation Flag
FSTAT_FCCF:         .equ   6                                        ; FLASH Command Complete Interrupt Flag
FSTAT_FCBEF:        .equ   7                                        ; FLASH Command Buffer Empty Flag
; bit position masks
mFSTAT_FBLANK:      .equ   %00000100
mFSTAT_FACCERR:     .equ   %00010000
mFSTAT_FPVIOL:      .equ   %00100000
mFSTAT_FCCF:        .equ   %01000000
mFSTAT_FCBEF:       .equ   %10000000


;*** FCMD - Flash Command Register; 0xFFFF9826 ***
FCMD:               .equ   $FFFF9826                                ;*** FCMD - Flash Command Register; 0xFFFF82E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_FCMD0:         .equ   0                                         ; Flash Command, bit 0
FCMD_FCMD1:         .equ   1                                         ; Flash Command, bit 1
FCMD_FCMD2:         .equ   2                                         ; Flash Command, bit 2
FCMD_FCMD3:         .equ   3                                         ; Flash Command, bit 3
FCMD_FCMD4:         .equ   4                                         ; Flash Command, bit 4
FCMD_FCMD5:         .equ   5                                         ; Flash Command, bit 5
FCMD_FCMD6:         .equ   6                                         ; Flash Command, bit 6
; bit position masks
mFCMD_FCMD0:        .equ   %00000001
mFCMD_FCMD1:        .equ   %00000010
mFCMD_FCMD2:        .equ   %00000100
mFCMD_FCMD3:        .equ   %00001000
mFCMD_FCMD4:        .equ   %00010000
mFCMD_FCMD5:        .equ   %00100000
mFCMD_FCMD6:        .equ   %01000000

mBlank         .equ       0x05
mBurstProg     .equ       0x25
mByteProg      .equ       0x20
mMassErase     .equ       0x41
mPageErase     .equ       0x40

;****  END  *********************************************************************************
